
/****** Object:  Trigger [TRG_PDV_VD_TROCA_CLI_FIDEL]    Script Date: 03/01/2014 10:29:10 ******/
DROP TRIGGER [dbo].[TRG_PDV_VD_TROCA_CLI_FIDEL]
GO

/****** Object:  Trigger [dbo].[TRG_PDV_VD_TROCA_CLI_FIDEL]    Script Date: 03/01/2014 10:29:10 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE TRIGGER [dbo].[TRG_PDV_VD_TROCA_CLI_FIDEL] ON [dbo].[PDV_VD] 

FOR UPDATE

AS

       DECLARE @CD_CLI        INT
       DECLARE @CD_EMP        INT
       DECLARE @CD_FILIAL   INT
       DECLARE @CD_VD          INT
       DECLARE @CD_IT          INT
	   DECLARE @CONS_FINAL     INT
       
BEGIN TRY

       --Se alterou o status da venda para cancelado

       IF UPDATE(CD_CLI) 

              SET @CD_CLI = ISNULL((SELECT top 1 i.CD_CLI 
                                     FROM INSERTED i INNER JOIN DELETED d ON
                                           i.CD_CLI <> d.CD_CLI), 0)

			  IF EXISTS (SELECT top 1 CD_CLI FROM RC_CLI WHERE CONS_FINAL=1 and CD_CLI=@CD_CLI) 
				  BEGIN
					  RETURN
				  END
			

              IF @CD_CLI > 0 AND @CONS_FINAL=0

                     BEGIN

                            ------------------------------------------------------------------------------------------------------------------------

                            -- Trocando o cliente da pontua??o

                            ------------------------------------------------------------------------------------------------------------------------

                            UPDATE cred 

                            SET CD_CLI = @CD_CLI

                            FROM RC_CLI_FIDELI_PONTOS_CREDITO cred INNER JOIN RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO vinc_cred ON

                                                 cred.CD_CTR_PONTOS = vinc_cred.CD_CTR_PONTOS                                                 

                                     INNER JOIN INSERTED i ON

                                                 vinc_cred.CD_EMP        = i.CD_EMP                                      

                                                 AND vinc_cred.CD_FILIAL = i.CD_FILIAL

                                                 AND vinc_cred.CD_VD     = i.CD_VD



                            ------------------------------------------------------------------------------------------------------------------------

                            -- INCLUI PONTUACAO SE N?O ENCONTRADO NO UPDATE ACIMA

                            ------------------------------------------------------------------------------------------------------------------------

                            SELECT 

                                          @CD_EMP     = i.CD_EMP

                                          ,@CD_FILIAL = i.CD_FILIAL

                                          ,@CD_VD        = i.CD_VD

                                          ,@CD_IT        = it.CD_IT

                            FROM INSERTED i INNER JOIN PDV_VD_IT it ON

                                   i.CD_EMP        = it.CD_EMP

                                   AND i.CD_FILIAL = it.CD_FILIAL

                                   AND i.CD_VD     = it.CD_VD

                            WHILE @@FETCH_STATUS=0

                                   BEGIN

                                          EXECUTE P_INCLUI_PONTOS_FIDEL @CD_EMP, @CD_FILIAL, @CD_VD, @CD_IT, NULL, NULL                          

                                   END

                            PRINT 'CONSLCUIDO'

                     END

                                          

END TRY

BEGIN CATCH

       ROLLBACK TRAN

       INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)

              SELECT

                     ERROR_NUMBER() AS numero,

                     ERROR_SEVERITY() AS severidade,

                     ERROR_STATE() AS estado,

                     ERROR_PROCEDURE() AS rotina,

                     ERROR_LINE() AS linha,

                     ERROR_MESSAGE() AS mensagem,

                     GETDATE() AS dtErro;       

END CATCH
GO


